-- new script file

function OnAfterSceneLoaded(self)
  self:AddTriggerTarget("victory")
  self:AddTriggerTarget("defeat")
end

function OnThink(self)
  if not self.initialized then
    self.initialized = true
    self.p0 = Citadels.GetPlayer(0)
    self.defeat = false
		self.victory = false
    
    if not self.loaded then
      self.timer = 5
      MarkMainGoal(self)      
    end
  end
  
  if self.defeat then
    self.p0:FailQuest('D6G_GOAL_1')
    
    td = Timer:GetTimeDiff()
    self.timer = self.timer - td
    
    if self.timer <= 0 then
      Citadels.ForceDefeat()
    end
  end
  
  if self.victory then
    self.p0:WinQuest('D6G_GOAL_1')
    
    td = Timer:GetTimeDiff()
    self.timer = self.timer - td
    
    if self.timer <= 0 then
		  Citadels.SetAchievementDone(11)
      Citadels.ForceVictory()
    end
  end
  
end

function MarkMainGoal(self)
  gPosX = Game:GetEntity("mainBase"):GetPosition().x
  gPosY = Game:GetEntity("mainBase"):GetPosition().y

  self.p0:AddQuest('D6G_GOAL_1','main')   
  self.p0:SetQuestPosition('D6G_GOAL_1', gPosX, gPosY)
end

function OnTrigger(self, source, target)
  if target == "victory" then
    self.victory = true
  elseif target == "defeat" then
    self.defeat = true
  end
end

function OnSerialize(self, ar)
  if (ar:IsLoading()) and Citadels.GetLoadGameRunning() then
    OnAfterSceneLoaded(self)
    self.loaded = true
    self.victory = ar:Read()
    self.timer = ar:Read()
  elseif (ar:IsSaving()) then
    ar:Write(self.victory)
    ar:Write(self.timer)
  end
end
